<?php

/**
 * Class that operate on table 'playstationclientcard'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:58
 */
class PlaystationclientcardMySqlDAO implements PlaystationclientcardDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PlaystationclientcardMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM playstationclientcard WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM playstationclientcard';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM playstationclientcard ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param playstationclientcard primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM playstationclientcard WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PlaystationclientcardMySql playstationclientcard
     */
    public function insert($playstationclientcard) {
        $sql = 'INSERT INTO playstationclientcard (cardid, clientid, buyDate, packVal, packPrice, packDays, packValConsumed, cardEndDate, cardStatus, userid, del, sysDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($playstationclientcard->cardid);
        $sqlQuery->setNumber($playstationclientcard->clientid);
        $sqlQuery->set($playstationclientcard->buyDate);
        $sqlQuery->set($playstationclientcard->packVal);
        $sqlQuery->set($playstationclientcard->packPrice);
        $sqlQuery->setNumber($playstationclientcard->packDays);
        $sqlQuery->set($playstationclientcard->packValConsumed);
        $sqlQuery->set($playstationclientcard->cardEndDate);
        $sqlQuery->setNumber($playstationclientcard->cardStatus);
        $sqlQuery->setNumber($playstationclientcard->userid);
        $sqlQuery->setNumber($playstationclientcard->del);
        $sqlQuery->set($playstationclientcard->sysDate);

        $id = $this->executeInsert($sqlQuery);
        $playstationclientcard->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PlaystationclientcardMySql playstationclientcard
     */
    public function update($playstationclientcard) {
        $sql = 'UPDATE playstationclientcard SET cardid = ?, clientid = ?, buyDate = ?, packVal = ?, packPrice = ?, packDays = ?, packValConsumed = ?, cardEndDate = ?, cardStatus = ?, userid = ?, del = ?, sysDate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($playstationclientcard->cardid);
        $sqlQuery->setNumber($playstationclientcard->clientid);
        $sqlQuery->set($playstationclientcard->buyDate);
        $sqlQuery->set($playstationclientcard->packVal);
        $sqlQuery->set($playstationclientcard->packPrice);
        $sqlQuery->setNumber($playstationclientcard->packDays);
        $sqlQuery->set($playstationclientcard->packValConsumed);
        $sqlQuery->set($playstationclientcard->cardEndDate);
        $sqlQuery->setNumber($playstationclientcard->cardStatus);
        $sqlQuery->setNumber($playstationclientcard->userid);
        $sqlQuery->setNumber($playstationclientcard->del);
        $sqlQuery->set($playstationclientcard->sysDate);

        $sqlQuery->setNumber($playstationclientcard->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM playstationclientcard';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCardid($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE cardid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuyDate($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE buyDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBypackVal($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE packVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPackPrice($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE packPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPackDays($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE packDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPackValConsumed($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE packValConsumed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCardEndDate($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE cardEndDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCardStatus($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE cardStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM playstationclientcard WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCardid($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE cardid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuyDate($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE buyDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBypackVal($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE packVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPackPrice($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE packPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPackDays($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE packDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPackValConsumed($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE packValConsumed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCardEndDate($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE cardEndDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCardStatus($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE cardStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM playstationclientcard WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PlaystationclientcardMySql
     */
    protected function readRow($row) {
        $playstationclientcard = new Playstationclientcard();

        $playstationclientcard->id = $row['id'];
        $playstationclientcard->cardid = $row['cardid'];
        $playstationclientcard->clientid = $row['clientid'];
        $playstationclientcard->buyDate = $row['buyDate'];
        $playstationclientcard->packVal = $row['packVal'];
        $playstationclientcard->packPrice = $row['packPrice'];
        $playstationclientcard->packDays = $row['packDays'];
        $playstationclientcard->packValConsumed = $row['packValConsumed'];
        $playstationclientcard->cardEndDate = $row['cardEndDate'];
        $playstationclientcard->cardStatus = $row['cardStatus'];
        $playstationclientcard->userid = $row['userid'];
        $playstationclientcard->del = $row['del'];
        $playstationclientcard->sysDate = $row['sysDate'];

        //
        $playstationclientcard->cardName = $row['cardName'];
        $playstationclientcard->clientname = $row['clientname'];

        return $playstationclientcard;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PlaystationclientcardMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>